/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.LootingModifierHook;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.DummyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ModifierLootingHandler {
    private static final Map<UUID, EquipmentSlot> LOOTING_OFFHAND = new HashMap<UUID, EquipmentSlot>();
    private static boolean init = false;

    public static void init() {
        if (init) {
            return;
        }
        init = true;
        MinecraftForge.EVENT_BUS.addListener(ModifierLootingHandler::onLooting);
        MinecraftForge.EVENT_BUS.addListener(ModifierLootingHandler::onLeaveServer);
    }

    public static void setLootingSlot(LivingEntity entity, EquipmentSlot slotType) {
        if (slotType == EquipmentSlot.MAINHAND) {
            LOOTING_OFFHAND.remove(entity.m_142081_());
        } else {
            LOOTING_OFFHAND.put(entity.m_142081_(), slotType);
        }
    }

    public static EquipmentSlot getLootingSlot(@Nullable LivingEntity entity) {
        return entity != null ? LOOTING_OFFHAND.getOrDefault(entity.m_142081_(), EquipmentSlot.MAINHAND) : EquipmentSlot.MAINHAND;
    }

    private static void onLooting(LootingLevelEvent event) {
        DamageSource damageSource = event.getDamageSource();
        if (damageSource == null) {
            return;
        }
        Entity source = damageSource.m_7639_();
        if (source instanceof LivingEntity) {
            LivingEntity holder = (LivingEntity)source;
            Entity direct = damageSource.m_7640_();
            int level = event.getLootingLevel();
            LivingEntity target = event.getEntityLiving();
            if (direct instanceof AbstractArrow) {
                ModifierNBT modifiers = EntityModifierCapability.getOrEmpty(direct);
                if (!modifiers.isEmpty()) {
                    ModDataNBT persistentData = direct.getCapability(PersistentDataCapability.CAPABILITY).map(ModDataNBT::new).orElseGet(ModDataNBT::new);
                    DummyToolStack tool = new DummyToolStack(Items.f_41852_, modifiers, persistentData);
                    level = LootingModifierHook.getLootingValue(TinkerHooks.PROJECTILE_LOOTING, tool, holder, (Entity)target, damageSource, 0);
                }
            } else {
                EquipmentSlot slotType = ModifierLootingHandler.getLootingSlot(holder);
                ItemStack held = holder.m_6844_(slotType);
                if (held.m_204117_(TinkerTags.Items.MODIFIABLE)) {
                    ToolStack tool = ToolStack.from(held);
                    level = ModifierUtil.getLootingLevel(tool, holder, (Entity)event.getEntityLiving(), damageSource);
                } else if (slotType != EquipmentSlot.MAINHAND) {
                    level = 0;
                }
            }
            level = ModifierUtil.getLeggingsLootingLevel(holder, (Entity)event.getEntityLiving(), damageSource, level);
            event.setLootingLevel(level);
        }
    }

    private static void onLeaveServer(PlayerEvent.PlayerLoggedOutEvent event) {
        LOOTING_OFFHAND.remove(event.getPlayer().m_142081_());
    }
}

